/*
 *	@(#) Space.c 7.1 94/11/27 SCOINC
 *
 *      Copyright (C) The Santa Cruz Operation, 1993-1994.
 *      This Module contains Proprietary Information of
 *      The Santa Cruz Operation and should be treated
 *      as Confidential.
 */

/*
 *	System V STREAMS TCP - Release 4.0
 *
 *	Copyright 1987, 1988 Lachman Associates, Incorporated (LAI)
 *
 *	All Rights Reserved.
 *
 *	The copyright above and this notice must be preserved in all
 *	copies of this source code.  The copyright above does not
 *	evidence any actual or intended publication of this source
 *	code.
 *
 *	This is unpublished proprietary trade secret source code of
 *	Lachman Associates.  This source code may not be copied,
 *	disclosed, distributed, demonstrated or licensed except as
 *	expressly authorized by Lachman Associates.
 *
 *	System V STREAMS TCP was jointly developed by Lachman
 *	Associates and Convergent Technologies.
 */
#include "sys/types.h"
#include "sys/stream.h"
#include "sys/mdi.h"
#include "config.h"
#include "space.h"
#include "u2e.h"

			/* IRQ LEVEL */
u_int u2eintl[U2E_CNTLS] = {
#ifdef U2E_0
	        U2E_0_IRQ,
#endif
#ifdef U2E_1
		U2E_1_IRQ,
#endif
#ifdef U2E_2
		U2E_2_IRQ,
#endif
#ifdef U2E_3
		U2E_3_IRQ,
#endif
};

			/* I/O BASE ADDRESS */
u_int u2eiobase[U2E_CNTLS] = {
#ifdef U2E_0
		U2E_0_BASE_IO,
#endif
#ifdef U2E_1
		U2E_1_BASE_IO,
#endif
#ifdef U2E_2
		U2E_2_BASE_IO,
#endif
#ifdef U2E_3
		U2E_3_BASE_IO,
#endif
};


u_int			u2e_nunit = U2E_CNTLS;
struct u2edevice	u2edevice[U2E_CNTLS];  

extern int u2eopen(), u2eclose(), u2euwput();
extern int nulldev();

struct module_info u2e_minfo = {
	0, "u2e", 1, u2eETHERMTU, 16*u2eETHERMTU, 12*u2eETHERMTU
};

struct qinit u2eurinit = {
	0,  0, u2eopen, u2eclose, nulldev, &u2e_minfo, 0
};

struct qinit u2euwinit = {
	u2euwput,0,u2eopen,u2eclose, nulldev, &u2e_minfo, 0
};

struct streamtab u2einfo = { &u2eurinit, &u2euwinit, 0, 0 };
